<?php $__env->startSection('header'); ?>
    <script src="<?php echo e(asset('asset/script/settings.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<style>
    .payment-gateway-card {
        background-color: rgb(245, 245, 245);
        border-radius: 10px;
    }
</style>

<?php $__env->startSection('content'); ?>
    <div>
        <ul class="nav nav-pills border-b mb-3  ml-0">

            <li role="presentation" class="nav-item"><a class="nav-link pointer active" href="#Section1" aria-controls="home"
                    role="tab" data-toggle="tab"><?php echo e(__('Settings')); ?><span class="badge badge-transparent "></span></a>
            </li>

            <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#Section5" role="tab"
                data-toggle="tab"><?php echo e(__('Appointment Reminders')); ?>

                <span class="badge badge-transparent "></span></a>
        </li>

            <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#Section2" role="tab"
                    data-toggle="tab"><?php echo e(__('Taxes')); ?>

                    <span class="badge badge-transparent "></span></a>
            </li>

            <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#Section3" role="tab"
                    data-toggle="tab"><?php echo e(__('Payment Gateways')); ?>

                    <span class="badge badge-transparent "></span></a>
            </li>

            <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#Section4" role="tab"
                    data-toggle="tab"><?php echo e(__('Admin Password')); ?>

                    <span class="badge badge-transparent "></span></a>
            </li>
        </ul>
    </div>

    <div class="tab-content tabs" id="home">
        
        <div role="tabpanel" class="card tab-pane active" id="Section1">
            <div class="card-header">
                <h6 class="text-dark"><?php echo e(__('Settings')); ?></h6>
            </div>
            <div class="card-body">

                <form Autocomplete="off" class="form-group form-border" id="globalSettingsForm" action=""
                    method="post">

                    <?php echo csrf_field(); ?>
                    <div class="form-row ">
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Currency Symbol (Displayed before price)')); ?></label>
                            <input value="<?php echo e($data->currency); ?>" type="text" class="form-control" name="currency"
                                required>
                        </div>

                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Platform Commission (%)')); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <i class="fas fa-percent"></i>
                                    </div>
                                </div>
                                <input value="<?php echo e($data->comission); ?>" type="number" class="form-control" name="comission">
                            </div>
                        </div>

                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Min. amount required to payout (Doctor)')); ?></label>
                            <input value="<?php echo e($data->min_amount_payout_doctor); ?>" type="text" class="form-control"
                                name="min_amount_payout_doctor" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Number of bookings users can have at a time')); ?></label>
                            <input value="<?php echo e($data->max_order_at_once); ?>" type="text" class="form-control"
                                name="max_order_at_once" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Support Email')); ?></label>
                            <input value="<?php echo e($data->support_email); ?>" type="text" class="form-control" name="support_email"
                                required>
                        </div>
                    </div>

                    <h6 class="text-dark"><?php echo e(__('ChatBot')); ?></h6>
                    <div class="form-row">
                        
                        <div class="form-group col-md-3">
                            <label class="" for=""><?php echo e(__('Enable ChatBot')); ?></label>
                            <br>
                            <label class="switch ml-1">
                                <input type="checkbox" name="enable_chatbot" id="chatBotSwitch"
                                    <?php echo e($data->enable_chatbot == 1 ? 'checked' : ''); ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label> <?php echo e(__('ChatBot Thumb')); ?></label>
                            <input accept="image/png, image/jpeg" type="file" name="chatbot_thumb" class="form-control">
                            <?php if($data->chatbot_thumb != null): ?>
                                <img class="mt-2 rounded shadow border" src="<?php echo e(env('FILES_BASE_URL')); ?><?php echo e($data->chatbot_thumb); ?>" alt="" height="60" width="60">
                            <?php endif; ?>
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Chatbot Name')); ?></label>
                            <input value="<?php echo e($data->chatbot_name); ?>" type="text" class="form-control" name="chatbot_name">
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('ChatGPT Token')); ?></label>
                            <input id="chatGPTToken" value="<?php echo e($data->chatgpt_token); ?>" type="text" class="form-control" name="chatgpt_token">
                        </div>
                    </div>

                    <div class="form-group-submit">
                        <button class="btn btn-primary " type="submit"><?php echo e(__('Save')); ?></button>
                    </div>
                </form>
            </div>
        </div>

        
        <div role="tabpanel" class="card tab-pane" id="Section2">
            <div class="card-header">
                <h6 class="text-dark"><?php echo e(__('Taxes')); ?></h6>

                <a data-toggle="modal" data-target="#addTaxModal" href=""
                    class="ml-auto btn btn-primary text-white"><?php echo e(__('Add Tax')); ?></a>
            </div>
            <div class="card-body">
                <div class="table-responsive col-12">
                    <table class="table table-striped w-100 word-wrap" id="taxesTable">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Tax Title')); ?></th>
                                <th><?php echo e(__('Type')); ?></th>
                                <th><?php echo e(__('Value')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

        
        <div role="tabpanel" class="card tab-pane" id="Section3">
            <div class="card-header">
                <h6 class="text-dark"><?php echo e(__('Payment Gateways')); ?></h6>
            </div>
            <div class="card-body">
                <form Autocomplete="off" class="form-group form-border" id="paymentGatewayForm" action=""
                    method="post">

                    <?php echo csrf_field(); ?>
                    <div class="">
                        <span>- The platform supports one payment gateway only at a time. So users can recharge the wallet
                            with
                            the selected gateway only.</span><br>
                        <span>- Make sure to add the <strong>Currency Code</strong> from the list of supported currencies by
                            the
                            payment gateways. Links are provided below each of them.</span><br>
                        <span>- Make sure that the <strong>Currency Symbol</strong> matches with the selected
                            <strong>Currency
                                Code</strong> to avoid confusions to user.</span><br>
                        <span>- Select the one gateway to use and then save it. Make sure to set required credentials for
                            that
                            gateways.</span>
                    </div>
                    <div class="form-row mt-3">
                        <div class="form-group col-md-4">
                            <label for="exampleFormControlSelect1"><?php echo e(__('Payment Gateway')); ?></label>

                            <select name="payment_gateway" class="form-control">
                                <option <?php echo e($data->payment_gateway == 1 ? 'selected' : ''); ?> value="1">
                                    <?php echo e(__('Stripe')); ?>

                                </option>
                                <option <?php echo e($data->payment_gateway == 3 ? 'selected' : ''); ?> value="3">
                                    <?php echo e(__('Razorpay')); ?></option>
                                <option <?php echo e($data->payment_gateway == 4 ? 'selected' : ''); ?> value="4">
                                    <?php echo e(__('Paystack')); ?></option>
                                <option <?php echo e($data->payment_gateway == 5 ? 'selected' : ''); ?> value="5">
                                    <?php echo e(__('PayPal')); ?>

                                </option>
                                <option <?php echo e($data->payment_gateway == 6 ? 'selected' : ''); ?> value="6">
                                    <?php echo e(__('Flutterwave')); ?></option>

                                <option <?php echo e($data->payment_gateway == 7 ? 'selected' : ''); ?> value="7">
                                    <?php echo e(__('SSLCommerze')); ?></option>
                            </select>
                        </div>
                    </div>

                    
                    <h5 class="text-dark d-block"><?php echo e(__('Stripe')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> <a href="https://stripe.com/docs/currencies"
                            target="_blank">https://stripe.com/docs/currencies</a> </p>

                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Public Key')); ?></label>
                            <input value="<?php echo e($data->stripe_publishable_key); ?>" type="text" class="form-control"
                                name="stripe_publishable_key">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Secret Key')); ?></label>
                            <input value="<?php echo e($data->stripe_secret); ?>" type="text" class="form-control"
                                name="stripe_secret">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?></label>
                            <input value="<?php echo e($data->stripe_currency_code); ?>" type="text" class="form-control"
                                name="stripe_currency_code">
                        </div>
                    </div>
                    
                    <h5 class="text-dark d-block mt-2"><?php echo e(__('Razorpay')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> <a
                            href="https://knowledgebase.razorpay.com/support/solutions/articles/82000533827-what-currencies-does-razorpay-support-"
                            target="_blank">https://knowledgebase.razorpay.com/support/solutions/articles/82000533827-what-currencies-does-razorpay-support-</a>
                    </p>
                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Razorpay Key')); ?></label>
                            <input value="<?php echo e($data->razorpay_key); ?>" type="text" class="form-control"
                                name="razorpay_key">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?></label>
                            <input value="<?php echo e($data->razorpay_currency_code); ?>" type="text" class="form-control"
                                name="razorpay_currency_code">
                        </div>
                    </div>

                    
                    <h5 class="text-dark d-block mt-2"><?php echo e(__('Paystack')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> <a
                            href="https://support.paystack.com/hc/en-us/articles/360009973779-What-currency-is-available-to-my-business-"
                            target="_blank">https://support.paystack.com/hc/en-us/articles/360009973779-What-currency-is-available-to-my-business-</a>
                    </p>

                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Public Key')); ?></label>
                            <input value="<?php echo e($data->paystack_public_key); ?>" type="text" class="form-control"
                                name="paystack_public_key">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Secret Key')); ?></label>
                            <input value="<?php echo e($data->paystack_secret_key); ?>" type="text" class="form-control"
                                name="paystack_secret_key">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?></label>
                            <input value="<?php echo e($data->paystack_currency_code); ?>" type="text" class="form-control"
                                name="paystack_currency_code">
                        </div>
                    </div>
                    
                    <h5 class="text-dark d-block mt-2"><?php echo e(__('PayPal')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> <a
                            href="https://developer.paypal.com/docs/reports/reference/paypal-supported-currencies/"
                            target="_blank">https://developer.paypal.com/docs/reports/reference/paypal-supported-currencies/</a>
                    </p>

                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Client Id')); ?></label>
                            <input value="<?php echo e($data->paypal_client_id); ?>" type="text" class="form-control"
                                name="paypal_client_id">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Secret Key')); ?></label>
                            <input value="<?php echo e($data->paypal_secret_key); ?>" type="text" class="form-control"
                                name="paypal_secret_key">
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?></label>
                            <input value="<?php echo e($data->paypal_currency_code); ?>" type="text" class="form-control"
                                name="paypal_currency_code">
                        </div>
                    </div>
                    
                    <h5 class="text-dark d-block mt-2"><?php echo e(__('Flutterwave')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> <a
                            href="https://flutterwave.com/tz/support/general/what-are-the-currencies-accepted-on-flutterwave"
                            target="_blank">https://flutterwave.com/tz/support/general/what-are-the-currencies-accepted-on-flutterwave</a>
                    </p>
                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Public Key')); ?></label>
                            <input value="<?php echo e($data->flutterwave_public_key); ?>" type="text" class="form-control"
                                name="flutterwave_public_key">
                        </div>

                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Secret Key')); ?></label>
                            <input value="<?php echo e($data->flutterwave_secret_key); ?>" type="text" class="form-control"
                                name="flutterwave_secret_key">
                        </div>
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Encryption Key')); ?></label>
                            <input value="<?php echo e($data->flutterwave_encryption_key); ?>" type="text" class="form-control"
                                name="flutterwave_encryption_key">
                        </div>
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?></label>
                            <input value="<?php echo e($data->flutterwave_currency_code); ?>" type="text" class="form-control"
                                name="flutterwave_currency_code">
                        </div>

                    </div>
                    
                    <h5 class="text-dark d-block mt-2"><?php echo e(__('SSLCommerze')); ?></h5>
                    <p class="text-muted"><?php echo e(__('Supported Currencies :')); ?> USD,BDT Only
                    </p>
                    <div class="form-row payment-gateway-card p-2">
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Store Id')); ?></label>
                            <input value="<?php echo e($data->sslcommerz_store_id); ?>" type="text" class="form-control"
                                name="sslcommerz_store_id">
                        </div>

                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Store Password')); ?></label>
                            <input value="<?php echo e($data->sslcommerz_store_passwd); ?>" type="text" class="form-control"
                                name="sslcommerz_store_passwd">
                        </div>
                        <div class="form-group col-md-3">
                            <label for=""><?php echo e(__('Currency Code (***)')); ?> USD & BDT only</label>
                            <input value="<?php echo e($data->sslcommerz_currency_code); ?>" type="text" class="form-control"
                                name="sslcommerz_currency_code">
                        </div>

                    </div>

                    <div class="form-group-submit mt-3">
                        <button class="btn btn-primary " type="submit"><?php echo e(__('Save')); ?></button>
                    </div>
                </form>
            </div>
        </div>

        
        <div role="tabpanel" class="card tab-pane" id="Section4">
            <div class="card-header">
                <h6 class="text-dark"><?php echo e(__('Admin Password')); ?></h6>
            </div>
            <div class="card-body">

                <form Autocomplete="off" class="form-group form-border" id="passwordForm" action=""
                    method="post">

                    <?php echo csrf_field(); ?>
                    <div class="">
                        <span>To change the password: Enter the password below and click on save.</span>
                    </div>
                    <div class="form-row mt-3">
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('Old Password')); ?></label>
                            <input type="text" class="form-control" name="old_password" value="" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for=""><?php echo e(__('New Password')); ?></label>
                            <input type="text" class="form-control" name="new_password" value="" required>
                        </div>

                    </div>
                    <div class="form-group-submit">
                        <button class="btn btn-primary " type="submit"><?php echo e(__('Save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
          
          <div role="tabpanel" class="card tab-pane" id="Section5">
            <div class="card-header">
                <h4><?php echo e(__('Appointment Reminders')); ?></h4>

                <a data-toggle="modal" data-target="#addReminderModal" href=""
                class="ml-auto btn btn-primary text-white"><?php echo e(__('Add New')); ?></a>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <span>Add how many reminders you want to have users before appointment time for each appointments.<br> These will be activated only once the appointment is accepted by doctor. <br> And make sure that you have configured the cron job correctly.<br> New settings applies for new appointments only.</span>
                </div>
                <div class="table-responsive col-12">
                    <table class="table table-striped w-100 word-wrap" id="remindersTable">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Day')); ?></th>
                                <th><?php echo e(__('Hour')); ?></th>
                                <th><?php echo e(__('Minute')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>

     
     <div class="modal fade" id="addReminderModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
     aria-hidden="true">
     <div class="modal-dialog modal-dialog-centered" role="document">
         <div class="modal-content">
             <div class="modal-header">
                 <h6><?php echo e(__('Add Reminder')); ?></h6>

                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                 </button>
             </div>
             <div class="modal-body">

                 <form action="" method="post" enctype="multipart/form-data" id="addReminderForm"
                     autocomplete="off">
                     <?php echo csrf_field(); ?>

                     <div class="form-row">

                         <div class="form-group col-md-4">
                             <label> <?php echo e(__('Day')); ?></label>
                             <select name="day" class="form-control">
                                 <?php for($i = 0; $i <= 10; $i++): ?>
                                 <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                 <?php endfor; ?>
                             </select>
                         </div>
                         <div class="form-group col-md-4">
                             <label> <?php echo e(__('Hour')); ?></label>
                             <select name="hr" class="form-control">
                                 <?php for($i = 0; $i <= 24; $i++): ?>
                                 <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                 <?php endfor; ?>
                             </select>
                         </div>
                         <div class="form-group col-md-4">
                             <label> <?php echo e(__('Minutes')); ?></label>
                             <select name="min" class="form-control">
                                 <?php for($i = 0; $i <= 60; $i++): ?>
                                 <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                 <?php endfor; ?>
                             </select>
                         </div>
                     </div>

                     <div class="form-group">
                         <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                     </div>

                 </form>
             </div>

         </div>
     </div>
 </div>

    
    <div class="modal fade" id="addTaxModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6><?php echo e(__('Add Tax')); ?></h6>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="addTaxForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                            <label> <?php echo e(__('Tax Title')); ?></label>
                            <input type="text" name="tax_title" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Type')); ?></label>
                            <select name="type" class="form-control">
                                <option value="0"><?php echo e(__('Percent')); ?></option>
                                <option value="1"><?php echo e(__('Fixed')); ?></option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Value')); ?></label>
                            <input type="number" name="value" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>

    
    <div class="modal fade" id="editTaxModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6><?php echo e(__('Edit Tax')); ?></h6>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="editTaxForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="id" id="editTaxId">

                        <div class="form-group">
                            <label> <?php echo e(__('Tax Title')); ?></label>
                            <input id="edit_tax_title" type="text" name="tax_title" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Type')); ?></label>
                            <select id="edit_tax_type" name="type" class="form-control">

                            </select>
                        </div>
                        <div class="form-group">
                            <label> <?php echo e(__('Value')); ?></label>
                            <input id="edit_tax_value" type="number" name="value" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorio_backend\resources\views/settings.blade.php ENDPATH**/ ?>