<?php $__env->startSection('header'); ?>
    <script src="<?php echo e(asset('asset/script/viewDoctorProfile.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('asset/style/viewDoctorProfile.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <input type="hidden" value="<?php echo e($doctor->id); ?>" id="doctorId">

    <div class="card">
        <div class="card-header">
            <img class="rounded-circle img-border mr-2" width="40" height="40"
                src="<?php echo e(env('FILES_BASE_URL')); ?><?php echo e($doctor->image); ?>" alt="">
            <h4>
                <?php echo e($doctor->name); ?> / <?php echo e($doctor->doctor_number); ?>

            </h4>


            
            <?php if($doctor->status == $doctorStatus['statusDoctorPending']): ?>
                <span class="badge bg-warning text-white "><?php echo e(__('Pending Review')); ?> </span>
            <?php elseif($doctor->status == $doctorStatus['statusDoctorApproved']): ?>
                <span class="badge bg-success text-white "><?php echo e(__('Active')); ?> </span>
            <?php elseif($doctor->status == $doctorStatus['statusDoctorBanned']): ?>
                <span class="badge bg-danger text-white "><?php echo e(__('Banned')); ?> </span>
            <?php endif; ?>


            
            <?php if($doctor->status == $doctorStatus['statusDoctorPending']): ?>
                <a href="" id="approveDoctor"
                    class="ml-auto btn btn-success activateDoctor"><?php echo e(__('Approve Doctor')); ?></a>
            <?php elseif($doctor->status == $doctorStatus['statusDoctorApproved']): ?>
                <a href="" id="banDoctor" class="ml-auto btn btn-danger text-white"><?php echo e(__('Ban Doctor')); ?></a>
            <?php elseif($doctor->status == $doctorStatus['statusDoctorBanned']): ?>
                <a href="" id="activateDoctor"
                    class="ml-auto btn btn-success activateDoctor"><?php echo e(__('Activate Doctor')); ?></a>
            <?php endif; ?>

        </div>
        <div class="card-body">

            <div class="form-row">

                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Mobile Number')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($doctor->visible_mobile_number); ?></p>
                </div>
                <div class="col-md-2">
                    <label class="mb-0 text-grey d-block" for=""><?php echo e(__('Gender')); ?></label>
                    <?php if($doctor->gender == 1): ?>
                        <span class="badge bg-primary text-white "><?php echo e(__('Male')); ?></span>
                    <?php else: ?>
                        <span class="badge bg-info text-white "><?php echo e(__('Female')); ?></span>
                    <?php endif; ?>
                </div>
                <div class="col-md-2">
                    <label class="mb-0 text-grey d-block" for=""><?php echo e(__('Category')); ?></label>
                    <span class="badge bg-primary text-white mr-2"><?php echo e($doctor->category->title); ?></span>
                </div>

                
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Online Consultation')); ?></label>
                    <?php if($doctor->online_consultation == 0): ?>
                        <p class="mt-0 p-data"><?php echo e(__('No')); ?></p>
                    <?php else: ?>
                        <p class="mt-0 p-data"><?php echo e(__('Yes')); ?></p>
                    <?php endif; ?>
                </div>
                
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Clinic Consultation')); ?></label>
                    <?php if($doctor->clinic_consultation == 0): ?>
                        <p class="mt-0 p-data"><?php echo e(__('No')); ?></p>
                    <?php else: ?>
                        <p class="mt-0 p-data"><?php echo e(__('Yes')); ?></p>
                    <?php endif; ?>
                </div>

            </div>

            <div class="form-row mt-3">
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Wallet')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($settings->currency); ?><?php echo e($doctor->wallet); ?></p>
                </div>
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Lifetime Earnings')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($settings->currency); ?><?php echo e($doctor->lifetime_earnings); ?></p>
                </div>
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Total Patients Cured')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($doctor->total_patients_cured); ?></p>
                </div>

                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('Overall Rating')); ?></label>
                    <p class="mt-0 p-data"><?php echo e($doctor->rating); ?></p>
                </div>

                
                <div class="col-md-2">
                    <label class="mb-0 text-grey" for=""><?php echo e(__('On Vacation')); ?></label>
                    <?php if($doctor->on_vacation == 0): ?>
                        <p class="mt-0 p-data"><?php echo e(__('No')); ?></p>
                    <?php else: ?>
                        <p class="mt-0 p-data"><?php echo e(__('Yes')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="form-row mt-2">
                <div class="col-md-2">
                    <div class="bank-details">
                        <span><?php echo e(__('Bank Details :')); ?></span>
                        <?php if($doctor->bankAccount != null): ?>
                            <span class="text-dark font-14"><?php echo e(__('Holder : ')); ?><?php echo e($doctor->bankAccount->holder); ?></span>
                            <span
                                class="text-dark font-14"><?php echo e(__('Bank : ')); ?><?php echo e($doctor->bankAccount->bank_name); ?></span>
                            <span
                                class="text-dark font-14"><?php echo e(__('Account : ')); ?><?php echo e($doctor->bankAccount->account_number); ?></span>
                            <span
                                class="text-dark font-14"><?php echo e(__('Swift Code : ')); ?><?php echo e($doctor->bankAccount->swift_code); ?></span>
                            <a id="chequePhoto" data-cheque="<?php echo e(env('FILES_BASE_URL') . $doctor->bankAccount->cheque_photo); ?>" target="_blank" class="badge bg-primary text-white mt-1"
                            href=""><?php echo e(__('Cheque Photo')); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="bank-details">
                        <span><?php echo e(__('Clinic Details :')); ?></span>

                        <span class="text-dark font-14"><?php echo e(__('Clinic Name : ')); ?><?php echo e($doctor->clinic_name); ?></span>
                        <span class="text-dark font-14"><?php echo e(__('Clinic Address : ')); ?><?php echo e($doctor->clinic_address); ?></span>

                        <a target="_blank" class="badge bg-primary text-white mt-1"
                            href="https://www.google.com/maps/?q=<?php echo e($doctor->clinic_lat); ?>,<?php echo e($doctor->clinic_long); ?>"><?php echo e(__('Click To Locate')); ?></a>

                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <ul class="nav nav-pills border-b  ml-0">

                <li role="presentation" class="nav-item"><a class="nav-link pointer active" href="#tabDetails"
                        aria-controls="home" role="tab" data-toggle="tab"><?php echo e(__('Details')); ?><span
                            class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabAppointments" role="tab"
                        aria-controls="tabAppointments" data-toggle="tab"><?php echo e(__('Appointments')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabReviews" role="tab"
                        aria-controls="tabReviews" data-toggle="tab"><?php echo e(__('Reviews')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabReels" role="tab"
                        data-toggle="tab"><?php echo e(__('Reels')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabWallet" role="tab"
                        data-toggle="tab"><?php echo e(__('Wallet')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabPayOuts" role="tab"
                        data-toggle="tab"><?php echo e(__('Payouts')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabEarningHistory"
                        role="tab" data-toggle="tab"><?php echo e(__('Earnings')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabServices" role="tab"
                        data-toggle="tab"><?php echo e(__('Services')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabExpertise"
                        role="tab" data-toggle="tab"><?php echo e(__('Expertise')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabExperience"
                        role="tab" data-toggle="tab"><?php echo e(__('Experience')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabServiceLocations"
                        role="tab" data-toggle="tab"><?php echo e(__('Service Locations')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>

                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabAwards" role="tab"
                        data-toggle="tab"><?php echo e(__('Awards')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabHolidays" role="tab"
                        data-toggle="tab"><?php echo e(__('Holidays')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>
                <li role="presentation" class="nav-item"><a class="nav-link pointer" href="#tabSlots" role="tabSlots"
                        data-toggle="tab"><?php echo e(__('Slots')); ?>

                        <span class="badge badge-transparent "></span></a>
                </li>



            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content tabs" id="home">

                
                <div role="tabpanel" class="tab-pane active" id="tabDetails">

                    <div class="form-group mt-0">
                        <div class="d-flex mb-2">
                            <div class="salon_image">
                                <img width="100" class="rounded" height="100"
                                    src="<?php echo e(env('FILES_BASE_URL')); ?><?php echo e($doctor->image); ?>" alt="">
                            </div>
                        </div>
                    </div>


                    <form action="" method="post" enctype="multipart/form-data" class=""
                        id="doctorDetailsForm" autocomplete="off">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="id" value="<?php echo e($doctor->id); ?>">

                        <div class="form-row ">
                            <div class="form-group col-md-3">
                                <label for=""><?php echo e(__('Designation')); ?></label>
                                <input type="text" class="form-control" name="designation"
                                    value="<?php echo e($doctor->designation); ?>">
                            </div>
                            <div class="form-group col-md-3">
                                <label for=""><?php echo e(__('Languages Spoken')); ?></label>
                                <input type="text" class="form-control" name="languages_spoken"
                                    value="<?php echo e($doctor->languages_spoken); ?>">
                            </div>
                            <div class="form-group col-md-3">
                                <label for=""><?php echo e(__('Experience Years')); ?></label>
                                <input type="number" class="form-control" name="experience_year"
                                    value="<?php echo e($doctor->experience_year); ?>">
                            </div>
                            <div class="form-group col-md-3">
                                <label for=""><?php echo e(__('Consultation Fees')); ?></label>
                                <input type="number" class="form-control" name="consultation_fee"
                                    value="<?php echo e($doctor->consultation_fee); ?>">
                            </div>
                        </div>

                        <div class="form-row ">
                            <div class="form-group col-md-4">
                                <label for=""><?php echo e(__('Degrees')); ?></label>
                                <textarea style="height:100px !important;" type="text" class="form-control" name="degrees"><?php echo e($doctor->degrees); ?></textarea>
                            </div>
                            <div class="form-group col-md-4">
                                <label for=""><?php echo e(__('About')); ?></label>
                                <textarea style="height:100px !important;" type="text" class="form-control" name="about_youself"><?php echo e($doctor->about_youself); ?></textarea>
                            </div>
                            <div class="form-group col-md-4">
                                <label for=""><?php echo e(__('Educational Journey')); ?></label>
                                <textarea style="height:100px !important;" type="text" class="form-control" name="educational_journey"><?php echo e($doctor->educational_journey); ?></textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>


                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabAppointments">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="appointmentsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Appointments Number')); ?></th>
                                    <th><?php echo e(__('User')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Date & Time')); ?></th>
                                    <th><?php echo e(__('Service Amount')); ?></th>
                                    <th><?php echo e(__('Discount Amount')); ?></th>
                                    <th><?php echo e(__('Subtotal')); ?></th>
                                    <th><?php echo e(__('Total Tax Amount')); ?></th>
                                    <th><?php echo e(__('Payable Amount')); ?></th>
                                    <th><?php echo e(__('Order Date')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabReviews">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="reviewsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Rating')); ?></th>
                                    <th class="w-30"><?php echo e(__('Comment')); ?></th>
                                    <th><?php echo e(__('Appointment')); ?></th>
                                    <th><?php echo e(__('Date&Time')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabReels">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="reelsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Thumb')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Stats')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabWallet">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="walletStatementTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Transaction ID')); ?></th>
                                    <th><?php echo e(__('Summary')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Credit/Debit')); ?></th>
                                    <th><?php echo e(__('Date & Time')); ?></th>
                                </tr>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabPayOuts">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="doctorPayOutsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Request Number')); ?></th>
                                    <th><?php echo e(__('Bank Details')); ?></th>
                                    <th><?php echo e(__('Amount & Status')); ?></th>
                                    <th><?php echo e(__('Placed On')); ?></th>
                                    <th><?php echo e(__('Summary')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabEarningHistory">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="earningsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Earning Number')); ?></th>
                                    <th><?php echo e(__('Appointment Number')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Date')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabServices">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="servicesTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabExpertise">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="expertiseTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabServiceLocations">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="serviceLocationsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Hospital Name')); ?></th>
                                    <th><?php echo e(__('Hospital Address')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <div role="tabpanel" class="tab-pane" id="tabExperience">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="experienceTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabAwards">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="awardsTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabHolidays">
                    <div class="table-responsive col-12">
                        <table class="table table-striped w-100 word-wrap" id="holidaysTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div role="tabpanel" class="tab-pane" id="tabSlots">
                    <div class="table-responsive col-12">
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Monday')); ?></label>
                            <?php $__currentLoopData = $slots['mondaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Tuesday')); ?></label>
                            <?php $__currentLoopData = $slots['tuesdaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Wednesday')); ?></label>
                            <?php $__currentLoopData = $slots['wednesdaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Thursday')); ?></label>
                            <?php $__currentLoopData = $slots['thursdaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Friday')); ?></label>
                            <?php $__currentLoopData = $slots['thursdaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Saturday')); ?></label>
                            <?php $__currentLoopData = $slots['saturdaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-2">
                            <label class="mb-0 text-grey" for=""><?php echo e(__('Sunday')); ?></label>
                            <?php $__currentLoopData = $slots['sundaySlots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge bg-info text-white "><?php echo e($item['time']); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>

      
      <div class="modal fade" id="chequePhotoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
      aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5><?php echo e(__('Cheque Photo')); ?></h5>

                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              <div class="modal-body">
                <img id="chequePhotoImg" width="100%" src="" alt="">
              </div>

          </div>
      </div>
  </div>


    
    <div class="modal fade" id="previewGalleryModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Preview Gallery Post')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p id="descGalleryPreview"></p>
                    <img class="rounded" width="100%" id="imggalleryPreview" src="" alt="">
                </div>

            </div>
        </div>
    </div>

    
    <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Reject Withdrawal')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="rejectForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="rejectId" name="id">
                        <div class="form-group">
                            <label> <?php echo e(__('Summary')); ?></label>
                            <textarea rows="10" style="height:200px !important;" type="text" name="summary" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
    
    <div class="modal fade" id="completeModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo e(__('Complete Withdrawal')); ?></h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="" method="post" enctype="multipart/form-data" id="completeForm"
                        autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="completeId" name="id">
                        <div class="form-group">
                            <label> <?php echo e(__('Summary')); ?></label>
                            <textarea rows="10" style="height:200px !important;" type="text" name="summary" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <input class="btn btn-primary mr-1" type="submit" value=" <?php echo e(__('Submit')); ?>">
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
      
      <div class="modal fade" id="video_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
      aria-hidden="true">
      <div class="modal-dialog">
          <div class="modal-content">
              <div class="modal-header">
                  <h5><?php echo e(__('View Reel')); ?></h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              <div class="modal-body">
                  <p id="videoDesc"></p>
                  <video rel="" id="video" width="450" height="450" controls>
                      <source src="" type="video/mp4">
                      Your browser does not support the video tag.
                  </video>
              </div>

          </div>
      </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorio_backend\resources\views/viewDoctorProfile.blade.php ENDPATH**/ ?>